--[[
This file is intended to be run by macro.lua
See macro-readme.html for help and instructions.

You can define more gamekey modules below.
You may put anything on the left except the following reserved characters:
 . W w _ ^ * + - < / > ( ) [ ] $ & # ! ?
]]

single = { --for emulators with a single control scheme
--{emulator = emu name, players = nplayers, keymap = {{key1 symbol, key1 name}, {key2 symbol, key2 name}, ...}},
	{
		emulator = FCEU,
		players = 4,
		keymap = {
			{"U", "up"},
			{"D", "down"},
			{"L", "left"},
			{"R", "right"},
			{"1", "A"},
			{"2", "B"},
			{"S", "start"},
			{"@", "select"},
		},
	},
	{
		emulator = snes9x,
		players = 5,
		keymap = {
			{"U", "up"},
			{"D", "down"},
			{"L", "left"},
			{"R", "right"},
			{"1", "Y"},
			{"2", "X"},
			{"3", "L"},
			{"4", "B"},
			{"5", "A"},
			{"6", "R"},
			{"S", "start"},
			{"@", "select"},
		},
	},
	{
		emulator = vba,
		players = 1,
		keymap = {
			{"U", "up"},
			{"D", "down"},
			{"L", "left"},
			{"R", "right"},
			{"1", "B"},
			{"2", "A"},
			{"3", "L"},
			{"4", "R"},
			{"S", "start"},
			{"@", "select"},
		},
	},
	{
		emulator = gens,
		players = 2,
		keymap = {
			{"U", "up"},
			{"D", "down"},
			{"L", "left"},
			{"R", "right"},
			{"1", "X"},
			{"2", "Y"},
			{"3", "Z"},
			{"4", "A"},
			{"5", "B"},
			{"6", "C"},
			{"S", "start"},
			{"M", "mode"},
		},
	},
	{
		emulator = pcejin,
		players = 5,
		keymap = { --PCEjin doesn't work yet because the script has no way of identifying it.
			{"U", "Up"},
			{"D", "Down"},
			{"L", "Left"},
			{"R", "Right"},
			{"1", "I"},
			{"2", "II"},
			{"3", "III"},
			{"4", "IV"},
			{"5", "V"},
			{"6", "VI"},
			{"S", "Run"},
			{"@", "Select"},
		},
	},
	{
		emulator = {pcsx, psxjin},
		players = 2,
		keymap = {
			{"U", "up"},
			{"D", "down"},
			{"L", "left"},
			{"R", "right"},
			{"1", "square"},
			{"2", "triangle"},
			{"3", "r1"},
			{"4", "x"},
			{"5", "circle"},
			{"6", "r2"},
			{"7", "l1"},
			{"8", "l2"},
			{"S", "start"},
			{"@", "select"},
		},
	},
}

arcade = { --for FBA/MAME, which have multiple control schemes
--{games = {driver/parent1 name, parent2 name, ...}, players = nplayers,
--keymap = {{key1 symbol, key1 FBA name, key1 MAME name}, {key2 symbol, key2 FBA name, key2 MAME name}, ...}},
	{
		games = {"neodrvr.c", "neogeo"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Button A", "P# Button 1"},
			{"2", "P# Button B", "P# Button 2"},
			{"3", "P# Button C", "P# Button 3"},
			{"4", "P# Button D", "P# Button 4"},
			{"S", "P# Start",    "# Player Start"},
			{"`", "P# Select"},
			{"C", "P# Coin",     "Coin #"},
			{"@", "Test",        "Enter BIOS"},
			{"~", "Reset"},
		},
	},
	{
		games = {"pgm.c", "pgm"},
		players = 4,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Button 1"},
			{"2", "P# Button 2"},
			{"3", "P# Button 3"},
			{"4", "P# Button 4"},
			{"S", "P# Start",      "# Player Start"},
			{"C", "P# Coin",       "Coin #"},
			{"@", "Diagnostics 1"},
			{"~", "Reset"},
		},
	},
	{
		games = {"sf", "sftm", "sfex", "sfexp", "sfex2", "sfex2p"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Button 1"},
			{"2", "P# Button 2"},
			{"3", "P# Button 3"},
			{"4", "P# Button 4"},
			{"5", "P# Button 5"},
			{"6", "P# Button 6"},
			{"S", "P# Start"},
			{"C", "Coin #"},
			{"~", "Reset"},
		},
	},
	{
		games = {"sf2", "sf2ce", "sf2hf",
			"ssf2", "ssf2t", "hsf2", "sfa", "sfa2", "sfa3", "sfz2al",
			"sfiii", "sfiii2", "sfiii3", "redearth", "jojo", "jojoba",
			"xmcota", "xmvsf", "msh", "mshvsf", "mvsc", "dstlk", "nwarr", "vsav", "vhunt2", "vsav2"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Weak Punch",   "P# Button 1"},
			{"2", "P# Medium Punch", "P# Button 2"},
			{"3", "P# Strong Punch", "P# Button 3"},
			{"4", "P# Weak Kick",    "P# Button 4"},
			{"5", "P# Medium Kick",  "P# Button 5"},
			{"6", "P# Strong Kick",  "P# Button 6"},
			{"S", "P# Start",        "# Player Start"},
			{"C", "P# Coin",         "Coin #"},
			{"@", "Diagnostic",      "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"ringdest"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Hold",         "P# Button 1"},
			{"2", "P# Weak punch",   "P# Button 2"},
			{"3", "P# Strong punch", "P# Button 3"},
			{"5", "P# Weak kick",    "P# Button 5"},
			{"6", "P# Strong kick",  "P# Button 6"},
			{"S", "P# Start",        "# Player Start"},
			{"C", "P# Coin",         "Coin #"},
			{"@", "Diagnostic",      "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"cybots"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Low Attack",  "P# Button 1"},
			{"2", "P# High Attack", "P# Button 2"},
			{"3", "P# Boost",       "P# Button 3"},
			{"4", "P# Weapon",      "P# Button 4"},
			{"S", "P# Start",       "# Player Start"},
			{"C", "P# Coin",        "Coin #"},
			{"@", "Diagnostic",     "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"sgemf"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Punch",   "P# Button 1"},
			{"2", "P# Kick",    "P# Button 2"},
			{"3", "P# Special", "P# Button 3"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"avsp"},
		players = 3,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Shot",    "P# Button 1"},
			{"2", "P# Attack",  "P# Button 2"},
			{"3", "P# Jump",    "P# Button 3"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"ddtod", "ddsom"},
		players = 4,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Attack",  "P# Button 1"},
			{"2", "P# Jump",    "P# Button 2"},
			{"3", "P# Select",  "P# Button 3"},
			{"4", "P# Use",     "P# Button 4"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"megaman", "megaman2"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Fire",    "P# Button 1"},
			{"2", "P# Jump",    "P# Button 2"},
			{"3", "P# Select",  "P# Button 3"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
	},
	{
		games = {"forgottn"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Attack",  "P# Button 1"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
		analog = {
			{"T", "P# Turn", "Dial #"},
		},
	},
	{
		games = {"pzloop2"},
		players = 2,
		keymap = {
			{"U", "P# Up"},
			{"D", "P# Down"},
			{"L", "P# Left"},
			{"R", "P# Right"},
			{"1", "P# Shot",    "P# Button 1"},
			{"S", "P# Start",   "# Player Start"},
			{"C", "P# Coin",    "Coin #"},
			{"@", "Diagnostic", "Service Mode"},
			{"~", "Reset"},
		},
		analog = {
			{"P", "P# Paddle", "Dial #"},
		},
	},
}
